 ; Ŀ
 ;   Mplot - plot all drawings contained in a multi-drawing.               
 ;   Copyright 1998, 2006 by Rocket Software Ltd.                          
 ;   Pasta swim fins - these typically work best al dente.                 
 ; 
 ; Need to add ps/ms ability and call NP.


 ; Ŀ
 ;   Subroutine Sqmark: grdraw a box from two opposite corners.            
 ; 
 (DEFUN SQMARK (p1 p2)
  (setq col 2)
  (grdraw p1 p2 col)
  (grdraw (list (car p1) (cadr p2)) (list (car p2) (cadr p1)) col)
  (grdraw p1 (list (car p1) (cadr p2)) col)
  (grdraw (list (car p1) (cadr p2)) p2 col)
  (grdraw p2 (list (car p2) (cadr p1)) col)
  (grdraw (list (car p2) (cadr p1)) p1 col)
 (princ))
 ; Ŀ
 ;   Subroutine Sqmark end.                                                
 ; 

 ; Ŀ
 ;   Mplot: the Subroutine.                                                
 ; 
 (DEFUN MPLOT (enam mark / blnam pa p1 p2 ss entt doit rota scarab)
  (setq doit t)                   ; debugging aid: don't plot if nil
  (setq pa (cdr (assoc 10 (setq entt (entget enam)))))
  (setq blnam (cdr (assoc 2 entt)))
  (setq rota (cdr (assoc 50 entt)))
  (setq scarab (getvar "screenboxes"))
  (if blnam (grtext (1- scarab) blnam) (grtext))
 ; Ŀ
 ;   The drawing is on one side and we have not rotated the tb.            
 ; 
  (cond ((and (= blnam "ROTULO2")
              (equal rota (* pi 0.5) 0.00001))
         (setq p1 (polar (polar pa (* pi 0.5) 10) pi 10))
         (setq p2 (polar (polar pa (* pi 1.5) 206) 0 287))
         (if mark (sqmark p1 p2))
         (if doit (plot1 p1 p2 "0,0" "0")))
 ; Ŀ
 ;   The drawing is on one side and we have rotated the tb.                
 ; 
        ((and (= blnam "ROTULO2")
              (equal rota (* pi 1.5) 0.00001))
         (setq p1 (polar (polar pa (* pi 1.5) 25.5) pi 39))
         (setq p2 (polar (polar p1 (/ pi 2) 210.5) 0 297.5))
         (if mark (sqmark p1 p2))
         (if doit (plot1 p1 p2 "0,0" "0")))
 ; Ŀ
 ;   The drawing is upright and so is (surprisingly) the tb.               
 ; 
        ((and (= blnam "ROTULO2")
              (equal rota 0 0.00001))
 ; Ŀ
 ;   See which of the two borders the tb is located in.                    
 ; 
         (setq ss (ssget "C" (polar pa (/ pi 2) 15) (polar pa (/ pi 2) 7)))
         (if (= 2 (sslength ss))
             (setq p1 (polar (polar pa (* pi 0.5) 10.5) 0 17.5))
             (setq p1 (polar (polar pa (* pi 0.5) 10.5) 0 10.5)))
         (setq p2 (polar (polar p1 pi 210.5) (* pi 1.5) 297.5))
         (if mark (sqmark p1 p2))
         (if doit (plot1 p1 p2 "0,-14" "90")))
 ; Ŀ
 ;   Now do the normal (upright) A size tb.                                
 ; 
        ((= blnam "ROTULO")
         (setq p1 (polar (polar pa 0 10.5) (* pi 1.5) 10.5))
         (setq p2 (polar (polar p1 pi 210.5) (/ pi 2) 297.5))
         (if mark (sqmark p1 p2))
         (if doit (plot1 p1 p2 "0,-14" "90")))
 ; Ŀ
 ;   The Rot A size tb, rotated 90 degrees ccw.                            
 ; 
        ((and (= blnam "ROT")
              (equal rota (* pi 0.5) 0.00001))
         (setq p2 (polar (polar pa pi 297) (/ pi 2) 210))
         (if mark (sqmark pa p2))
         (if doit (plot1 pa p2 "0,0" "0")))
 ; Ŀ
 ;   The Rot A size tb, upright.                                           
 ; 
        ((and (= blnam "ROT")
              (equal rota 0 0.00001))
         (setq p2 (polar (polar pa 0 210) (/ pi 2) 297))
         (if mark (sqmark pa p2))
         (if doit (plot1 pa p2 "0,0" "90")))
 ; Ŀ
 ;   The Tridyne TB.                                                       
 ; 
        ((= blnam "TRIDYNE_TB_D")
         (setq p1 (polar (polar pa pi 1) (* pi 1.5) 1))
         (setq p2 (polar (polar p1 0 865) (/ pi 2) 559))
         (if mark (sqmark p1 p2))
         (if doit (plot1 p1 p2 "C" "0")))
 ; Ŀ
 ;   Xr-Tblk (Toromont).                                                   
 ; 
        ((= blnam "XR-TBLK")
         (setq p1 (polar (polar pa pi 1) (* pi 1.5) 1))
         (setq p2 (polar (polar p1 0 131) (/ pi 2) 85))
         (if mark (sqmark p1 p2))
         (if doit (plot1 p1 p2 "C" "0")))
 ; Ŀ
 ;   The default - no tb was found.                                        
 ; 
        (t (prompt "\n** No known Title Block indicated. **")))
 (princ))
 ; Ŀ
 ;   Mplot end.                                                            
 ; 

 ; Ŀ
 ;   Plot1 - Plot a windowed area/subdrawing.                              
 ; 
 (DEFUN PLOT1 (p1 p2 orig rota /)
  (command "-plot")
  (command "y")                   ; Detailed plot configuration? [Yes/No] <No>:
  (command "Model")               ; Layout name or [?] <Model>:
  (command "MarkPrinter.pc3")     ; Output device name or [?]:
  (command "11x17")               ; Paper size or [?]:
  (command "Inches")              ; Paper units [Inches/Millimeters]:
  (command "Landscape")           ; Drawing orientation [Portrait/Landscape]:
  (command "No")                  ; Plot upside down? [Yes/No] <No>:
  (command "Window")              ; Plot area [Display/Extents/Limits/View/Window]:
  (command p1)                    ; Lower left corner of window:
  (command p2)                    ; Upper right corner of window:
  (command "Fit")                 ; Plot scale (Plotted Inches=Drawing Units) or [Fit]:
  (command orig)                  ; Plot offset (x,y) or [Center] <Center>:
  (command "Y")                   ; Plot with plot styles? [Yes/No] <Yes>:
  (command "Tridyne Black B.ctb") ; Plot style table name or [?]:
  (command "Y")                   ; Plot with lineweights? [Yes/No] <Yes>:
  (command "As Displayed")        ; Shade plot setting [As displayed/Wireframe/Hidden/Rendered]:
  (command "N")                   ; Write the plot to a file [Yes/No] <N>:
  (command "N")                   ; Save changes to page setup [Yes/No]? <N>
  (command "Y")                   ; Proceed with plot [Yes/No] <Y>: n
 (princ))
 ; Ŀ
 ;   Plot1 end.                                                            
 ; 

 ; Ŀ
 ;   Mplot.                                                                
 ; 
 (DEFUN C:MPLOT (/ ss num enam)
  (prompt "Select title blocks to plot or <Return> for all:")
  (if (null (setq ss (ssget '((-4 . "<or")
                              (2 . "rotulo2") (2 . "rotulo") (2 . "rot")
                              (2 . "tridyne_tb_d") (2 . "xr-tblk")
                              (-4 . "or>")))))
      (setq ss (ssget "X" '((-4 . "<or")
                            (2 . "rotulo2") (2 . "rotulo") (2 . "rot")
                            (2 . "tridyne_tb_d") (2 . "xr-tblk")
                            (-4 . "or>")))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (mplot enam t))
 (princ))